statemachine class W3XbowEnergy extends CGameplayEntity 
{	
	var ent : CEntity;
	var movementAdjustor 														: CMovementAdjustor;
	var ticket 			 														: SMovementAdjustmentRequestTicket;	
	var targetent																: CEntity;
	var time 																	: float;
	var quen_action                                                             : W3DamageAction;
	var damage                                                                  : Float;
	var spellpower 																: SAbilityAttributeValue;
	var quen_victim																: CNewNPC;	
	var entities 																: array< CActor >;
	var randenemy, i 															: int;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		//this.AddTimer('debug', 0.1, true);
		//time = theGame.GetEngineTimeAsSeconds();
		this.AddTimer('shoot0', 0.95, true);
	}
	
	event OnDestroyed()
	{
	}

    timer function shoot0(deltaTime : float, id : int) 
	{
		deal_damage();
	}
	
	function deal_damage()
	{
	
		//FindGameplayEntitiesInRange(entities, thePlayer, 10, 10,,FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
		entities.Clear();
		entities = GetWitcherPlayer().GetNPCsAndPlayersInRange( 20, 100, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors );
		if( entities.Size()>0 )
		{
			randenemy = RandRange ( entities.Size() );	
			quen_victim = (CNewNPC)entities[randenemy];
			
			this.SoundEvent("sign_yrden_shock_activate");
		
			damage = get_damage_value_for_cone_far( (CActor)quen_victim, get_spellpower_spells( false, S_Magic_4 ) );
			damage *= get_xbow_spells_dmg_mod();
			damage += damage * get_overall_mult();
			
			quen_action = new W3DamageAction in this;
			quen_action.Initialize(thePlayer,quen_victim,this,thePlayer.GetName()+"_sign",EHRT_Heavy,CPS_Undefined,false,false,true,false);	
			quen_action.SetProcessBuffsIfNoDamage(true);
			
			quen_action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage );

			if ( spells_can_dismember( (CActor)quen_victim ) )
			{
				quen_action.SetForceExplosionDismemberment();
			}

			ent = ((CActor) quen_victim).CreateFXEntityAtPelvis( 'explosions', true );
			ent.PlayEffect( 'old_gods_hit' );
			ent.DestroyAfter(5);
			ent.SoundEvent("sign_yrden_shock_activate");

			this.PlayEffect('yrden_shock_activate', ent);

			theGame.damageMgr.ProcessAction( quen_action );
			delete quen_action;
		}
	}
}	

state fucking_bolt_hack in W3BoltProjectile
{
	var ent			: CEntity;
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( parent.HasTag('deployedent_xbow_yrden') )
		{
			parent.StopProjectile();
			parent.RemoveTag('deployedent_xbow_yrden');
			parent.StopAllEffects();
			parent.DestroyAfter(3);
			
			ent = theGame.GetEntityByTag( 'dummmy_xbow_yrden' );
			ent.StopAllEffects();
			ent.PlayEffect( 'explode_yrden' );
			ent.DestroyAfter(7);
			ent.RemoveTag( 'dummmy_xbow_yrden' );
			
			deal_damage_bolt_yrden ( ent.GetWorldPosition() );
		}
		else
		if ( parent.HasTag('deployedent_xbow_axii') )
		{
			parent.StopProjectile();
			parent.RemoveTag('deployedent_xbow_axii');
			parent.StopAllEffects();
			parent.DestroyAfter(3);
			
			ent = theGame.GetEntityByTag( 'dummmy_xbow_axii' );
			
			ent.StopAllEffects();
			ent.PlayEffect( 'explode_axii' );
			ent.DestroyAfter(7);
			ent.RemoveTag( 'dummmy_xbow_axii' );
			ent.SoundEvent("sign_yrden_warmup"); ent.SoundEvent("sign_yrden_warmup"); ent.SoundEvent("sign_yrden_warmup");
			
			deal_damage_bolt_axii ( ent.GetWorldPosition() );
		}
		else
		if ( parent.HasTag('deployedent_xbow_igni') )
		{
			if(collidingComponent)
				parent.victim = (CGameplayEntity)collidingComponent.GetEntity();
				
			if ( parent.victim && parent.victim.IsAlive() && !parent.collidedEntities.Contains(parent.victim) && parent.victim != thePlayer 
				&& GetAttitudeBetween( (CActor)parent.victim, thePlayer ) == AIA_Hostile )
			{
				proc_dmg_xbow_igni( parent.victim, parent, parent.GetWorldPosition() );	
				parent.collidedEntities.PushBack( parent.victim );
			}
		}
		else
		if ( parent.HasTag('deployedent_xbow_aard') )
		{
			if(collidingComponent)
				parent.victim = (CGameplayEntity)collidingComponent.GetEntity();
				
			if ( parent.victim && parent.victim.IsAlive() && !parent.collidedEntities.Contains(parent.victim) && parent.victim != thePlayer 
				&& GetAttitudeBetween( (CActor)parent.victim, thePlayer ) == AIA_Hostile )
			{
				proc_dmg_xbow_aard( parent.victim, parent, parent.GetWorldPosition() );	
				parent.collidedEntities.PushBack( parent.victim );
			}
		}
	}
}
function proc_dmg_xbow_igni( victim : CGameplayEntity, thisp : W3BoltProjectile, pos : Vector )
{
	var action 						: W3DamageAction;
	var victimTags, attackerTags 	: array<name>;
	var damage 						: float;
	var effect_entity				: CEntity;
	
	damage = get_damage_value_for_projectile( ((CActor) victim), get_spellpower_spells( false, S_Magic_2 ) );
	damage *= get_xbow_spells_dmg_mod();
	damage += damage * get_overall_mult();
	
	action = new W3DamageAction in NULL;
	action.Initialize(thePlayer,victim,NULL,thePlayer.GetName(),EHRT_Light,CPS_AttackPower,false,true,false,false);				
	action.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage  );
	action.SetProcessBuffsIfNoDamage(true);
	((W3Action_Attack) action).SetApplyBuffsIfParried(true);
	action.SetHitEffect('igni_cone_hit', false, false);
	action.SetHitEffect('igni_cone_hit', true, false);
	
	if( RandF() <= 0.5 )
	{
		action.AddEffectInfo( EET_Burning, 1 );
	}
	//action.AddEffectInfo( EET_Bleeding, 2 );
	
	//effect_entity = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'fire_gnosis_effects' ), pos  );
	effect_entity = ((CActor) victim).CreateFXEntityAtPelvis( 'fire_gnosis_effects', true );
	effect_entity.PlayEffect( 'flame' );
	effect_entity.SoundEvent( 'ep2_mutations_09_bolt_impact_armor_type' );
	effect_entity.DestroyAfter(5);
	
	/*
	effect_entity = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'mutation9_hit' ), pos  );
	effect_entity.PlayEffect( 'hit_refraction' );
	effect_entity.SoundEvent( 'ep2_mutations_09_bolt_impact_armor_type' );
	effect_entity.DestroyAfter(5);
	*/
	
	if ( spells_can_dismember( ((CActor) victim) ) )
	{
		action.SetForceExplosionDismemberment();
	}
	
	theGame.damageMgr.ProcessAction( action );
	delete action;
	
	victimTags = victim.GetTags();
	attackerTags = thePlayer.GetTags();
	
	AddHitFacts( victimTags, attackerTags, "_arrow_hit" );
}
function proc_dmg_xbow_aard( victim : CGameplayEntity, thisp : W3BoltProjectile, pos : Vector )
{
	var action 						: W3DamageAction;
	var victimTags, attackerTags 	: array<name>;
	var damage 						: float;
	var effect_entity				: CEntity;
	
	damage = get_damage_value_for_projectile( ((CActor) victim), get_spellpower_spells( false, S_Magic_1 ) );
	damage *= get_xbow_spells_dmg_mod();
	damage += damage * get_overall_mult();
	
	action = new W3DamageAction in NULL;
	action.Initialize(thePlayer,victim,NULL,thePlayer.GetName(),EHRT_Light,CPS_AttackPower,false,true,false,false);				
	action.AddDamage(theGame.params.DAMAGE_NAME_FORCE, sp_force_dmg_mod() * damage );
	action.SetProcessBuffsIfNoDamage(true);
	((W3Action_Attack) action).SetApplyBuffsIfParried(true);
	
	if( RandF() <= 0.7 )
	{
		action.AddEffectInfo( EET_LongStagger );
	}
	else
	{
		action.AddEffectInfo( EET_Knockdown, 2 );
	}
	action.AddEffectInfo( EET_Bleeding, 2 );
	
	//effect_entity =  theGame.CreateEntity( (CEntityTemplate)LoadResource( 'sword_ring_small_effects' ), pos  );
	effect_entity = ((CActor) victim).CreateFXEntityAtPelvis( 'sword_ring_small_effects', true );
	effect_entity.PlayEffect( 'aard_sword_hit' );
	effect_entity.SoundEvent( 'ep2_mutations_09_bolt_impact_armor_type' );
	effect_entity.DestroyAfter(5);
	
	/*
	effect_entity = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'mutation9_hit' ), pos  );
	effect_entity.PlayEffect( 'hit_refraction' );
	effect_entity.SoundEvent( 'ep2_mutations_09_bolt_impact_armor_type' );
	effect_entity.DestroyAfter(5);
	*/
	
	if ( spells_can_dismember( ((CActor) victim) ) )
	{
		action.SetForceExplosionDismemberment();
	}
	
	theGame.damageMgr.ProcessAction( action );
	delete action;
	
	victimTags = victim.GetTags();
	attackerTags = thePlayer.GetTags();
	
	AddHitFacts( victimTags, attackerTags, "_arrow_hit" );
}

function crossbow_shoot_lukatiel( deployedent : W3AdvancedProjectile )
{
	var effect, dummy, xbow 		: CEntity;
	var shoot_effect				: CEntityTemplate;	
	
	shoot_effect = (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\xbow\soceress_arcane_missile_xbow.w2ent", true );
	
	if ( deployedent )
	switch( GetWitcherPlayer().GetEquippedSign() )
	{
		case ST_Igni:
			{
				if ( !thePlayer.IsSwimming() )
				{
					deployedent.projSpeed = 60;
					deployedent.projAngle = 0;
					dummy = theGame.CreateEntity( shoot_effect, deployedent.GetWorldPosition(),deployedent.GetWorldRotation() );
					dummy.CreateAttachment(deployedent,'fire_point',Vector ( 0, 0.5, 0)) ;
					dummy.PlayEffect('fire_fx_igni'); dummy.PlayEffect('fire_fx_igni'); dummy.PlayEffect('fire_fx_igni');
					dummy.PlayEffect('fire_fx_igni2'); dummy.PlayEffect('fire_fx_igni2'); dummy.PlayEffect('fire_fx_igni2');
					dummy.StopAllEffectsAfter(1);
					dummy.DestroyAfter(4);
					dummy.AddTag('dummmy_xbow_igni');
					dummy.AddTag('dummy_shot_spells');
					deployedent.AddTag('deployedent_xbow_igni');
					
					deployedent.PushState('fucking_bolt_hack');
					
					thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");
				}
			}
			break;
		
		case ST_Yrden:
			{
				if ( !thePlayer.IsSwimming() )
				{
					deployedent.projSpeed = 20;
					deployedent.projAngle = 5;
					dummy = theGame.CreateEntity( shoot_effect, deployedent.GetWorldPosition(),deployedent.GetWorldRotation() );
					dummy.CreateAttachment(deployedent,'fire_point',Vector ( 0, 0.3, 0)) ;
					dummy.PlayEffectSingle('fire_fx_yrden');
					dummy.DestroyAfter(10);
					dummy.AddTag('dummmy_xbow_yrden');
					dummy.AddTag('dummy_shot_spells');
					deployedent.AddTag('deployedent_xbow_yrden');
					
					deployedent.PushState('fucking_bolt_hack');
				}
			}
			break;
		case ST_Quen:
			{
				if ( !thePlayer.IsSwimming() )
				{
					deployedent.projSpeed = 3;
					deployedent.projAngle = 0;
					dummy = theGame.CreateEntity( shoot_effect, deployedent.GetWorldPosition(),deployedent.GetWorldRotation() );
					dummy.CreateAttachment(deployedent,'fire_point',Vector ( 0, 0.3, 0)) ;
					dummy.PlayEffectSingle('fire_fx_quen');
					dummy.PlayEffectSingle('fire_fx_quen2');
					dummy.PlayEffectSingle('fire_fx_yrden2');
					dummy.StopAllEffectsAfter(10);
					dummy.DestroyAfter(13);
					dummy.AddTag('dummmy_xbow_quen');
					effect = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\xbow\energy_xbow.w2ent",true),
					deployedent.GetWorldPosition(),deployedent.GetWorldRotation() );
					effect.CreateAttachment(dummy);
					effect.AddTag('xbow_energy');
					effect.DestroyAfter(10);
					deployedent.AddTag('deployedent_xbow_quen');
				}
			}
			break;
		case ST_Aard:
			{
				deployedent.projSpeed = 60;
				deployedent.projAngle = 0;
				dummy = theGame.CreateEntity( shoot_effect, deployedent.GetWorldPosition(),deployedent.GetWorldRotation() );
				dummy.CreateAttachment(deployedent,'fire_point',Vector ( 0, 0.5, 0)) ;
				dummy.PlayEffect('fire_fx_aard'); dummy.PlayEffect('fire_fx_aard'); dummy.PlayEffect('fire_fx_aard');
				dummy.PlayEffect('fire_fx_aard2'); dummy.PlayEffect('fire_fx_aard2'); dummy.PlayEffect('fire_fx_aard2');
				dummy.StopAllEffectsAfter(1);
				dummy.DestroyAfter(4);
				dummy.AddTag('dummmy_xbow_aard');
				dummy.AddTag('dummy_shot_spells');
				
				deployedent.AddTag('deployedent_xbow_aard');
				
				deployedent.PushState('fucking_bolt_hack');
				
				thePlayer.SoundEvent("fx_rune_activate_aard");thePlayer.SoundEvent("fx_rune_activate_aard");thePlayer.SoundEvent("fx_rune_activate_aard");
			}
			break;
		case ST_Axii:
			{
				deployedent.projSpeed = 20;
				deployedent.projAngle = 5;
				dummy = theGame.CreateEntity( shoot_effect, deployedent.GetWorldPosition(),deployedent.GetWorldRotation() );
				dummy.CreateAttachment(deployedent,'fire_point',Vector ( 0, 0.3, 0 ) ) ;
				dummy.PlayEffectSingle('fire_fx_axii'); dummy.PlayEffectSingle('fire_fx_axii');
				dummy.DestroyAfter(10);
				dummy.AddTag('dummmy_xbow_axii');
				dummy.AddTag('dummy_shot_spells');
				
				deployedent.AddTag('deployedent_xbow_axii');
				
				deployedent.PushState('fucking_bolt_hack');
			}
			break;
		default:		
			break;
	}
}



function create_sword_rend_n_spells_effects( signtype : ESignType, stop : float )
{
	var templatename 	: string;
	var n 				: float;
	var effect 			: CEntity;
	var lenght			: float;
	var rotation		: EulerAngles;

	templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\rend_n_spells_sword.w2ent";
	
	lenght = 0.9;
	
	/*
	rotation.Roll += StringToInt( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_rot_roll' ) );
	rotation.Pitch += StringToInt( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_rot_pitch' ) );
	rotation.Yaw += StringToInt( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_rot_yaw' ) );
	*/
	
	rotation.Roll = 0;
	rotation.Pitch = 0;
	rotation.Yaw = 0;
	
	switch(signtype)
	{
		case ST_Igni:
			{
				if ( stop > 1 )
				{
					thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");
				}
				for( n=0.5; n<lenght; n+=0.2 )
				{	
					effect = theGame.CreateEntity( (CEntityTemplate) LoadResource( templatename,true ), thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation() );
					effect.CreateAttachment( thePlayer, 'r_weapon', Vector( 0, 0, 1*n ), rotation );
					effect.PlayEffectSingle('igni'); effect.PlayEffectSingle('igni1');
					effect.StopAllEffectsAfter( stop );
					effect.DestroyAfter(5);
				}
			}
			break;
	
		case ST_Axii:
			{
				if ( stop > 1 )
				{
					thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");
				}
				for( n=0.5; n<lenght; n+=0.2 )
				{	
					effect = theGame.CreateEntity( (CEntityTemplate) LoadResource( templatename,true ), thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation() );
					effect.CreateAttachment( thePlayer, 'r_weapon', Vector( 0, 0, 1*n ), rotation );
					effect.PlayEffectSingle('axii'); effect.PlayEffectSingle('axii1'); effect.PlayEffectSingle('axii2');
					effect.StopAllEffectsAfter( stop );
					effect.DestroyAfter(5);
				}
			}
			break;
		
		case ST_Aard:
			{
				if ( stop > 1 )
				{
					thePlayer.SoundEvent("fx_rune_activate_aard");thePlayer.SoundEvent("fx_rune_activate_aard");thePlayer.SoundEvent("fx_rune_activate_aard");
				}
				for( n=0.5; n<=lenght; n+=0.1 )
				{	
					effect = theGame.CreateEntity( (CEntityTemplate) LoadResource( templatename,true ), thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation() );
					effect.CreateAttachment( thePlayer, 'r_weapon', Vector( 0, 0, 1*n ) );
					effect.PlayEffectSingle('aard');
					effect.StopAllEffectsAfter( stop );
					effect.DestroyAfter(5);
				}
			}
			break;
		
		case ST_Quen:
			{
				if ( stop > 1 )
				{
					thePlayer.SoundEvent("fx_rune_activate_quen");thePlayer.SoundEvent("fx_rune_activate_quen");thePlayer.SoundEvent("fx_rune_activate_quen");
				}
				for( n=0.5; n<=lenght; n+=0.1 )
				{	
					effect = theGame.CreateEntity( (CEntityTemplate) LoadResource( templatename,true ), thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation() );
					effect.CreateAttachment( thePlayer, 'r_weapon', Vector( 0, 0, 1*n ) );
					effect.PlayEffectSingle('quen'); 
					if ( stop < 1 )
					{
						effect.PlayEffectSingle('quen1'); effect.PlayEffectSingle('quen2');
					}
					effect.StopAllEffectsAfter( stop );
					effect.DestroyAfter(5);
				}
			}
			break;
		
		case ST_Yrden:
			{
				if ( stop > 1 )
				{
					thePlayer.SoundEvent("fx_rune_activate_yrden");thePlayer.SoundEvent("fx_rune_activate_yrden");thePlayer.SoundEvent("fx_rune_activate_yrden");
				}
				for( n=0.5; n<=lenght; n+=0.1 )
				{	
					effect = theGame.CreateEntity( (CEntityTemplate) LoadResource( templatename,true ), thePlayer.GetWorldPosition(), thePlayer.GetWorldRotation() );
					effect.CreateAttachment( thePlayer, 'r_weapon', Vector( 0, 0, 1*n ) );
					effect.PlayEffectSingle('yrden');
					effect.StopAllEffectsAfter( stop );
					effect.DestroyAfter(5);
				}
			}
			break;
			
		default:		
			break;
	}
}

state SwordRingSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var permafrost_trap   								: W3PermafrostTrap;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var icespear										: W3PermafrostSpear;
	var dummy											: CEntity;
	var vector_attach 									: Vector;
	var proj 											: W3IceentityBolt;
	var animsett										: SAnimatedComponentSlotAnimationSettings;
	
	event OnEnterState( prevStateName : name )
	{
		animsett.blendIn = 0.5f;
		animsett.blendOut = 0.35f;
		
		if ( !theSound.SoundIsBankLoaded("ep2_mutations_06.bnk") )
		{
			theSound.SoundLoadBank( "ep2_mutations_06.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_man_mage.bnk") )
		{
			theSound.SoundLoadBank( "magic_man_mage.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_sorceress.bnk") )
		{
			theSound.SoundLoadBank( "magic_sorceress.bnk", false );
		}
		
		if ( parent.spell_name == 'lukatiel_sword' )
		{
			cast_spells_sword_ring_lukatiel();
		}
		else
		if ( parent.spell_name == '' )
		{
			cast_spells_sword_ring_rend();
		}
		else
		{
			if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_swordspells_to_camera') )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					parent.AddTimer('rotate_towards_target', 0.0001, true );
				}
				else
				{
					parent.AddTimer('rotate_towards_camera', 0.0000001f, true );
				}
			}
			else
			{
				parent.AddTimer('rotate_towards_camera', 0.0000001f, true );
			}
			
			GetMagicVigil().set_is_in_custom_anim ( true );
			GetMagicVigil().set_is_in_custom_anim_sword ( true );
			
			cast_spells_sword_ring();
		}
	}
	
	private entry function cast_spells_sword_ring_lukatiel()
	{
		var n 				: float;
		var CustomEffect	: SCustomEffectParams;
		var cast_comp		: bool;
	
		var spell  : CEntity;
		var spell2  : CEntity;
	
		cast_comp = false;
		
		register_cancel_input_spells();
		GetMagicVigil().set_is_in_custom_anim ( true );
		parent.can_interrupt = true;
		
		spell = thePlayer.CreateFXEntityAtBone( 'sword_ring_small_effects', 'l_hand', true );
		spell.DestroyAfter(10);
		spell.PlayEffect('spell');
		spell.StopAllEffectsAfter(2);
		spell.AddTag( 'spells_destroy_immediately' );
		
		spell2 = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'sword_ring_small_effects' ), thePlayer.GetWorldPosition() );
		spell2.CreateAttachment( thePlayer, 'r_weapon', Vector( 0, 0, 0 ) );
		spell2.DestroyAfter(10);
		spell2.AddTag( 'spells_destroy_immediately' );
		
		animsett.blendIn = 0.5f;
		animsett.blendOut = 0.5f;
		thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_work_sword_sharpening_02', 'PLAYER_SLOT', animsett );
		
		Sleep(1);
		
		spell2.PlayEffect('spell2');
		spell2.StopAllEffectsAfter(1.3);
		for( n = 0.1; n <= 1.1f; n += 0.025 )
		{	
			spell2.BreakAttachment();
			spell2.CreateAttachment( thePlayer, 'r_weapon', Vector( 0, 0, 1*n ) );
			
			if ( n >= 0.75 && !cast_comp )
			{
				CustomEffect.effectType = EET_LukatielSword;
				CustomEffect.creator = GetWitcherPlayer();
				CustomEffect.duration = 120;
				GetWitcherPlayer().AddEffectCustom( CustomEffect );
				
				GetWitcherPlayer().DrainStamina( ESAT_FixedValue, 50, 0.5 ); 
				
				cast_comp = true;
				
				parent.create_sword_standard_effects();
			}
			
			Sleep ( 0.04 );
			
		}
		
		
		//Sleep ( StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer' ) ) );
		Sleep ( 0.3 );
		
		parent.GotoState( 'Vigil_Dreaming' );		
	}
	
	private entry function cast_spells_sword_ring_rend()
	{
		var proj 			: W3TraceGroundProjectile;
		var position2		: Vector;
	
		switch( parent.signtype )
		{
			case ST_Yrden:
				{
					thePlayer.SoundEvent("magic_sorceress_vfx_lightning_bolt");
					thePlayer.SoundEvent("magic_sorceress_vfx_lightning_bolt");
				
					position = GetWitcherPlayer().GetWorldPosition() - GetWitcherPlayer().GetHeadingVector() * 2;
					position2 = GetWitcherPlayer().GetWorldPosition() + GetWitcherPlayer().GetHeadingVector() * 1.7;
					targetPosition = position2 + GetWitcherPlayer().GetHeadingVector() * 5;
					
					rotation = thePlayer.GetWorldRotation();
					rotation.Roll += 90;
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring.w2ent";
					effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), position, rotation);
					effect_entity.PlayEffect('fx_pushyrden');
					effect_entity.DestroyAfter(5);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring_proj_yrden.w2ent";
					proj = (W3TraceGroundProjectile)theGame.CreateEntity( (CEntityTemplate) LoadResource( parent.templatename, true ), position2 );
					proj.Init(NULL);
					proj.ShootProjectileAtPosition( 0, 10, targetPosition, 11 );
				}
				
				break;
			case ST_Quen:
				{
					thePlayer.SoundEvent("magic_man_push");
				
					position = GetWitcherPlayer().GetWorldPosition() - GetWitcherPlayer().GetHeadingVector() * 2;
					position2 = GetWitcherPlayer().GetWorldPosition() + GetWitcherPlayer().GetHeadingVector() * 1.7;
					targetPosition = position2 + GetWitcherPlayer().GetHeadingVector() * 5;
					
					rotation = thePlayer.GetWorldRotation();
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring.w2ent";
					effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), position2, rotation);
					effect_entity.PlayEffect('fx_pushquen');
					effect_entity.DestroyAfter(10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring_proj_quen.w2ent";
					proj = (W3TraceGroundProjectile)theGame.CreateEntity( (CEntityTemplate) LoadResource( parent.templatename, true ), position2 );
					proj.Init(NULL);
					proj.ShootProjectileAtPosition( 0, 10, targetPosition, 11 );
				}
				
				break;
			case ST_Igni:
				{
					thePlayer.SoundEvent('sign_igni_charge_begin');
				
					position = GetWitcherPlayer().GetWorldPosition() - GetWitcherPlayer().GetHeadingVector() * 1;
					position2 = GetWitcherPlayer().GetWorldPosition() + GetWitcherPlayer().GetHeadingVector() * 1.7;
					targetPosition = position2 + GetWitcherPlayer().GetHeadingVector() * 5;
					
					rotation = thePlayer.GetWorldRotation();
					rotation.Roll += 90;
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring.w2ent";
					effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), position, rotation);
					effect_entity.PlayEffect('fx_pushigni');
					effect_entity.DestroyAfter(5);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring_proj_igni.w2ent";
					proj = (W3TraceGroundProjectile)theGame.CreateEntity( (CEntityTemplate) LoadResource( parent.templatename, true ), position2 );
					proj.Init(NULL);
					proj.ShootProjectileAtPosition( 0, 10, targetPosition, 11 );
				}
				
				break;
			case ST_Axii:
				{
					thePlayer.SoundEvent('sign_igni_charge_begin');
					thePlayer.SoundEvent('ep2_mutations_06_frosty_aard');
				
					position = GetWitcherPlayer().GetWorldPosition() - GetWitcherPlayer().GetHeadingVector() * 1;
					position2 = GetWitcherPlayer().GetWorldPosition() + GetWitcherPlayer().GetHeadingVector() * 1.7;
					targetPosition = position2 + GetWitcherPlayer().GetHeadingVector() * 5;
					
					rotation = thePlayer.GetWorldRotation();
					rotation.Roll += 90;
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring.w2ent";
					effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), position, rotation);
					effect_entity.PlayEffect('fx_pushaxii');
					effect_entity.DestroyAfter(5);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring_proj_axii.w2ent";
					proj = (W3TraceGroundProjectile)theGame.CreateEntity( (CEntityTemplate) LoadResource( parent.templatename, true ), position2 );
					proj.Init(NULL);
					proj.ShootProjectileAtPosition( 0, 10, targetPosition, 11 );
				}
			
				break;
			case ST_Aard:
				{
					thePlayer.SoundEvent("magic_man_push");
				
					position = GetWitcherPlayer().GetWorldPosition() - GetWitcherPlayer().GetHeadingVector() * 2;
					position2 = GetWitcherPlayer().GetWorldPosition() + GetWitcherPlayer().GetHeadingVector() * 1.7;
					targetPosition = position2 + GetWitcherPlayer().GetHeadingVector() * 5;
					
					rotation = thePlayer.GetWorldRotation();
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring.w2ent";
					effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), position2, rotation);
					effect_entity.PlayEffect('fx_pushaard');
					effect_entity.DestroyAfter(10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\heavy_spells_sword_ring_proj_aard.w2ent";
					proj = (W3TraceGroundProjectile)theGame.CreateEntity( (CEntityTemplate) LoadResource( parent.templatename, true ), position2 );
					proj.Init(NULL);
					proj.ShootProjectileAtPosition( 0, 10, targetPosition, 11 );
				}
				
				break;
			default:		
				break;
		}
		parent.can_cast_rend_lukatiel = false;
		parent.GotoState( 'Vigil_Dreaming' );
	}
	
	
	private entry function cast_spells_sword_ring()
	{
		var golem_npc 			: CNewNPC;
		var bonusAbilityName	: name;
		var roots				: CEntity;
		
		register_cancel_input_spells();
	
		create_sword_rend_n_spells_effects( parent.signtype, 0.6 );
	
		switch( parent.spell_name )
		{
			case 'sword_axii_cone':
				{
					if( RandF() <= 0.5)
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_6_rp_70ms', 'PLAYER_SLOT', animsett );
					}
					else
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_8_rp_70ms', 'PLAYER_SLOT', animsett );
					}
					//thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_8_rp_70ms', 'PLAYER_SLOT', animsett ); // right
					
					thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");
					
					Sleep ( 0.7 );
					
					axii_sword_cone();
				}

				break;
			case 'sword_yrden_cone':
				{
					if( RandF() <= 0.5)
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_1_rp_70ms', 'PLAYER_SLOT', animsett );
					}
					else
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_1_lp_70ms', 'PLAYER_SLOT', animsett );
					}
					
					thePlayer.SoundEvent("fx_rune_activate_yrden");thePlayer.SoundEvent("fx_rune_activate_yrden");thePlayer.SoundEvent("fx_rune_activate_yrden");
					
					Sleep ( 0.4 );
					
					thePlayer.SoundEvent("sign_yrden_warmup");
					
					Sleep ( 0.3 );
					
					yrden_sword_cone();
				}

				break;
			case 'sword_quen_cone':
				{
					if( RandF() <= 0.5)
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_9_rp_70ms', 'PLAYER_SLOT', animsett );
					}
					else
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_4_rp_70ms', 'PLAYER_SLOT', animsett );
					}
					
					thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");
					
					Sleep ( 0.7 );
					
					quen_sword_cone();
				}

				break;
			case 'sword_igni_cone':
				{
					if( RandF() <= 0.5)
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_6_rp_70ms', 'PLAYER_SLOT', animsett );
					}
					else
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_8_rp_70ms', 'PLAYER_SLOT', animsett );
					}
					//thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_8_rp_70ms', 'PLAYER_SLOT', animsett ); // right
					
					thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");thePlayer.SoundEvent("fx_rune_activate_igni");
					
					Sleep ( 0.7 );
					
					igni_sword_cone();
				}
			case 'sword_aard_cone':
				{
					if( RandF() <= 0.5)
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_9_lp_70ms', 'PLAYER_SLOT', animsett );
					}
					else
					{	
						thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( 'man_geralt_sword_attack_strong_10_lp_70ms', 'PLAYER_SLOT', animsett );
					}
					
					thePlayer.SoundEvent("fx_rune_activate_aard");thePlayer.SoundEvent("fx_rune_activate_aard");thePlayer.SoundEvent("fx_rune_activate_aard");
					
					Sleep ( 0.75 );
					
					aard_sword_cone();
				}

				break;
			
			default:		
				break;
		}
		
	}
	
	
	private entry function axii_sword_cone()
	{
		thePlayer.SoundEvent('sign_igni_charge_begin');
		thePlayer.SoundEvent('ep2_mutations_06_frosty_aard');
	
		rotation = thePlayer.GetWorldRotation();
		rotation.Yaw += 90;
			
		position = thePlayer.GetWorldPosition() + thePlayer.GetHeadingVector()*1.3;
		position.Z += 1;
		
		parent.templatename = "dlc\magicspellsrev\data\entities\wintersouls.w2ent";
		
		main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
		main_effect.PlayEffect('winter_souls_cone');
		main_effect.DestroyAfter(10);
		
		FindGameplayEntitiesInCone(entities, thePlayer.GetWorldPosition(), VecHeading( thePlayer.GetHeadingVector() ), 80, 5, 100);
		for( i = 0; i < entities.Size(); i += 1 )   
		{
			if ( !entities[i].HasTag('spells_custom_projs') )
			{
				entities[i].OnAardHit( NULL );
			}
		}
		
		actors = thePlayer.GetNPCsAndPlayersInCone(6, VecHeading(thePlayer.GetHeadingVector()), 80, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
		for( i = 0; i < actors.Size(); i += 1 )
		{
			target = (CActor)actors[i];
			
			damage_value = get_damage_value_for_cone( target, GetMagicVigil().get_magic_spellpower() );
			damage_value *= get_sword_spells_dmg_mod();
			damage_value += damage_value * get_overall_mult();
			
			damage_action =  new W3DamageAction in this;
			damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
			damage_action.SetProcessBuffsIfNoDamage(true);
			damage_action.SetHitReactionType(EHRT_Heavy);
			damage_action.SetHitEffect('');
			damage_action.SetHitEffect('', true );
			damage_action.SetHitEffect('', false, true);
			damage_action.SetHitEffect('', true, true);
			damage_action.SetHitAnimationPlayType(EAHA_Default);
			
			damage_action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage_value );
			damage_action.AddEffectInfo( EET_SlowdownFrost, MaxF( 3, MinF( 8, get_spellpower_spells( false, S_Magic_1 )*3 ) ) );
			
			effect_entity = target.CreateFXEntityAtPelvis( 'wintersouls_effects', true );
			effect_entity.PlayEffect( 'wintersouls_flame' );
			effect_entity.DestroyAfter(5);
			
			if ( spells_can_dismember( target ) )
			{
				damage_action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( damage_action );
			delete damage_action;
		}
		
		GetMagicVigil().RemoveTimer( 'rotate_towards_target' );
		GetMagicVigil().RemoveTimer( 'rotate_towards_camera' );
		
		Spells_drain_stamina_cut( 0.5, parent.stamina_cost, parent.stamina_delay, parent.signskill );
		
		parent.can_interrupt = true;
		
		Sleep( 0.85 );
		//Sleep ( StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer' ) ) );
		
		parent.GotoState( 'Vigil_Dreaming' );

	}
	
	private entry function yrden_sword_cone()
	{
		var dummy_proj  			: W3SwordYrdenConeDummy;
		var targetPosition			: Vector;
	
		rotation = thePlayer.GetWorldRotation();
			
		position = thePlayer.GetWorldPosition() + thePlayer.GetHeadingVector()*1.3;
		
		parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\sword_ring_effects.w2ent";
		
		main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
		main_effect.PlayEffect('yrden_cone');
		main_effect.PlayEffect('yrden_cone1');
		main_effect.DestroyAfter(10);
		
		targetPosition = position + thePlayer.GetHeadingVector() * 11;
		dummy_proj = (W3SwordYrdenConeDummy)theGame.CreateEntity
		( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\sword_ring_yrden_cone_dummy.w2ent",true ), position );
		dummy_proj.AddTag( 'spells_custom_projs' );
		dummy_proj.Init(NULL);
		dummy_proj.ShootProjectileAtPosition(0,	15, targetPosition, 10 );
		dummy_proj.DestroyAfter(10);
		
		GetMagicVigil().RemoveTimer( 'rotate_towards_target' );
		GetMagicVigil().RemoveTimer( 'rotate_towards_camera' );
		
		Spells_drain_stamina_cut( 0.5, parent.stamina_cost, parent.stamina_delay, parent.signskill );
		
		parent.can_interrupt = true;
		
		Sleep( 0.85 );
		//Sleep ( StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer' ) ) );
		
		parent.GotoState( 'Vigil_Dreaming' );

	}
	
	private entry function quen_sword_cone()
	{
		thePlayer.SoundEvent('sign_igni_charge_begin');
	
		rotation = thePlayer.GetWorldRotation();
		rotation.Yaw += 90;
			
		position = thePlayer.GetWorldPosition() + thePlayer.GetHeadingVector()*1.3;
		position.Z += 1;
		
		parent.templatename = "dlc\magicspellsrev\data\entities\great_swamp.w2ent";
		
		main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
		main_effect.PlayEffect('great_swamp_cone_sword');
		main_effect.DestroyAfter(10);
		
		actors = thePlayer.GetNPCsAndPlayersInCone(6, VecHeading(thePlayer.GetHeadingVector()), 80, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
		for( i = 0; i < actors.Size(); i += 1 )
		{
			target = (CActor)actors[i];
			
			damage_value = get_damage_value_for_cone( target, GetMagicVigil().get_magic_spellpower() );
			damage_value *= get_sword_spells_dmg_mod();
			damage_value += damage_value * get_overall_mult();
			
			damage_action =  new W3DamageAction in this;
			damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
			damage_action.SetProcessBuffsIfNoDamage(true);
			damage_action.SetHitReactionType(EHRT_Heavy);
			damage_action.SetHitEffect('');
			damage_action.SetHitEffect('', true );
			damage_action.SetHitEffect('', false, true);
			damage_action.SetHitEffect('', true, true);
			damage_action.SetHitAnimationPlayType(EAHA_Default);
			
			if ( RandF() <=0.5 )
			{
				damage_action.AddEffectInfo( EET_Poison, 3 );
				//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			}
			
			damage_action.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value * 0.6 );
			damage_action.AddDamage(theGame.params.DAMAGE_NAME_POISON, sp_pois_dmg_mod() * damage_value * 0.6 );
			
			effect_entity = target.CreateFXEntityAtPelvis( 'great_swamp_effects', true );
			effect_entity.PlayEffect( 'flame_from_cone' );
			effect_entity.DestroyAfter(5);
			
			if ( spells_can_dismember( target ) )
			{
				damage_action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( damage_action );
			delete damage_action;
		}
		
		GetMagicVigil().RemoveTimer( 'rotate_towards_target' );
		GetMagicVigil().RemoveTimer( 'rotate_towards_camera' );
		
		Spells_drain_stamina_cut( 0.5, parent.stamina_cost, parent.stamina_delay, parent.signskill );
		
		parent.can_interrupt = true;
		
		Sleep( 0.85 );
		//Sleep ( StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer' ) ) );
		
		parent.GotoState( 'Vigil_Dreaming' );

	}
	
	private entry function igni_sword_cone()
	{
		thePlayer.SoundEvent('sign_igni_charge_begin');
	
		rotation = thePlayer.GetWorldRotation();
		rotation.Yaw += 90;
			
		position = thePlayer.GetWorldPosition() + thePlayer.GetHeadingVector()*1.3;
		position.Z += 1;
		
		parent.templatename = "dlc\magicspellsrev\data\entities\fire_gnosis.w2ent";
		
		main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
		main_effect.PlayEffect('fire_gnosis_cone_sword');
		main_effect.DestroyAfter(10);
		
		actors = thePlayer.GetNPCsAndPlayersInCone(6, VecHeading(thePlayer.GetHeadingVector()), 80, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
		for( i = 0; i < actors.Size(); i += 1 )
		{
			target = (CActor)actors[i];
			
			damage_value = get_damage_value_for_cone( target, GetMagicVigil().get_magic_spellpower() );
			damage_value *= get_sword_spells_dmg_mod();
			damage_value += damage_value * get_overall_mult();
			
			damage_action =  new W3DamageAction in this;
			damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
			damage_action.SetProcessBuffsIfNoDamage(true);
			damage_action.SetHitReactionType(EHRT_Heavy);
			damage_action.SetHitEffect('');
			damage_action.SetHitEffect('', true );
			damage_action.SetHitEffect('', false, true);
			damage_action.SetHitEffect('', true, true);
			damage_action.SetHitAnimationPlayType(EAHA_Default);
			
			if ( RandF() <=0.25 )
			{
				damage_action.AddEffectInfo( EET_Burning, 1 );
				//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			}
			
			damage_action.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value );
			
			effect_entity = target.CreateFXEntityAtPelvis( 'fire_gnosis_effects', true );
			effect_entity.PlayEffect( 'flame' );
			effect_entity.DestroyAfter(5);
			
			if ( spells_can_dismember( target ) )
			{
				damage_action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( damage_action );
			delete damage_action;
		}
		
		GetMagicVigil().RemoveTimer( 'rotate_towards_target' );
		GetMagicVigil().RemoveTimer( 'rotate_towards_camera' );
		
		Spells_drain_stamina_cut( 0.5, parent.stamina_cost, parent.stamina_delay, parent.signskill );
		
		parent.can_interrupt = true;
		
		Sleep( 0.85 );
		//Sleep ( StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer' ) ) );
		
		parent.GotoState( 'Vigil_Dreaming' );

	}
	
	private entry function aard_sword_cone()
	{
		var dummy_proj  			: W3SwordAardConeDummy;
		var targetPosition			: Vector;
	
		thePlayer.SoundEvent("magic_man_push");
	
		rotation = thePlayer.GetWorldRotation();
			
		position = thePlayer.GetWorldPosition() + thePlayer.GetHeadingVector()*1.3;
		
		parent.templatename = "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\sword_ring_effects.w2ent";
		
		main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
		main_effect.PlayEffect('aard_cone');
		main_effect.DestroyAfter(10);
		
		targetPosition = position + thePlayer.GetHeadingVector() * 11;
		dummy_proj = (W3SwordAardConeDummy)theGame.CreateEntity
		( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\sword_ring_lukatiel\sword_ring_aard_cone_dummy.w2ent",true ), position );
		dummy_proj.AddTag( 'spells_custom_projs' );
		dummy_proj.Init(NULL);
		dummy_proj.ShootProjectileAtPosition(0,	15, targetPosition, 10 );
		dummy_proj.DestroyAfter(10);
		
		GetMagicVigil().RemoveTimer( 'rotate_towards_target' );
		GetMagicVigil().RemoveTimer( 'rotate_towards_camera' );
		
		Spells_drain_stamina_cut( 0.5, parent.stamina_cost, parent.stamina_delay, parent.signskill );
		
		parent.can_interrupt = true;
		
		Sleep( 0.85 );
		//Sleep ( StringToFloat( theGame.GetInGameConfigWrapper().GetVarValue( 'magic_spells_main', 'debug_proj_timer' ) ) );
		
		parent.GotoState( 'Vigil_Dreaming' );

	}
	
	
	event OnLeaveState( nextStateName : name )
	{
	}
}